/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.impl;

import com.bxm.localnews.common.exception.BusinessException;
import com.bxm.localnews.merchant.config.MerchantProperties;
import com.bxm.localnews.merchant.domain.MerchantCategoryMapper;
import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.domain.MerchantUserPromotionFlowMapper;
import com.bxm.localnews.merchant.dto.MerchantMarqueeDTO;
import com.bxm.localnews.merchant.dto.PromoteDetailDTO;
import com.bxm.localnews.merchant.dto.PromoteMoneyDTO;
import com.bxm.localnews.merchant.dto.UserInfoDTO;
import com.bxm.localnews.merchant.dto.UserPromoteMoneyDTO;
import com.bxm.localnews.merchant.entity.MerchantCategoryEntity;
import com.bxm.localnews.merchant.facade.UserFeignService;
import com.bxm.localnews.merchant.param.PromoteParam;
import com.bxm.localnews.merchant.service.promote.MerchantUserProAccountService;
import com.bxm.localnews.merchant.service.promote.PromoteService;
import com.bxm.localnews.merchant.vo.MerchantUserAccountVO;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.vo.PageWarper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PromoteServiceImpl
implements PromoteService {
    private static final Logger log = LoggerFactory.getLogger(PromoteServiceImpl.class);
    private MerchantInfoMapper merchantInfoMapper;
    private MerchantUserProAccountService merchantUserProAccountService;
    private UserFeignService userFeignService;
    private MerchantCategoryMapper merchantCategoryMapper;
    private MerchantUserPromotionFlowMapper merchantUserPromotionFlowMapper;
    private MerchantProperties merchantProperties;

    @Override
    public PromoteMoneyDTO getPromoteMoney(Long userId, Long promoteType) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByUserId(userId);
        if (null == merchantInfo) {
            throw new BusinessException("\u5546\u6237\u4e0d\u5b58\u5728");
        }
        promoteType = merchantInfo.getCategoryId();
        MerchantCategoryEntity merchantCategoryEntity = this.merchantCategoryMapper.selectByPrimaryKey(promoteType);
        if (Objects.isNull(merchantCategoryEntity)) {
            throw new BusinessException("\u5f53\u524d\u884c\u4e1a\u6682\u4e0d\u652f\u6301\u5f00\u901a\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
        }
        PromoteMoneyDTO resultProMoney = new PromoteMoneyDTO();
        resultProMoney.setInterestId(promoteType);
        resultProMoney.setMerchantId(merchantInfo.getId());
        resultProMoney.setMerchantName(merchantInfo.getMerchantName());
        resultProMoney.setTotalMoney(Objects.isNull(merchantCategoryEntity.getVipPrice()) ? BigDecimal.ZERO : merchantCategoryEntity.getVipPrice());
        resultProMoney.setOriginalMoney(this.merchantProperties.getDefaultOriginalPromoteAmt());
        MerchantUserAccountVO userAccountVO = this.merchantUserProAccountService.getUserProAccount(merchantInfo.getId());
        BigDecimal userTotalPromote = Objects.isNull(userAccountVO) || Objects.isNull(userAccountVO.getAbleProCash()) ? BigDecimal.ZERO : userAccountVO.getAbleProCash();
        resultProMoney.setLeftPromoteMoney(userTotalPromote);
        BigDecimal realPay = resultProMoney.getTotalMoney().subtract(userTotalPromote);
        if (realPay.compareTo(BigDecimal.ZERO) < 0) {
            resultProMoney.setMoney(BigDecimal.ZERO);
            resultProMoney.setPromoteMoney(resultProMoney.getTotalMoney());
        } else {
            resultProMoney.setMoney(realPay);
            resultProMoney.setPromoteMoney(userTotalPromote);
        }
        return resultProMoney;
    }

    @Override
    public PageWarper<PromoteDetailDTO> getPromoteDetail(PromoteParam promoteParam) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByUserId(promoteParam.getUserId());
        if (null != merchantInfo) {
            return new PageWarper(this.merchantUserPromotionFlowMapper.getListByMerchantId(merchantInfo.getId()));
        }
        return new PageWarper();
    }

    @Override
    public UserPromoteMoneyDTO getUserPromoteMoney(Long userId) {
        MerchantInfo merchantInfo = this.merchantInfoMapper.selectByUserId(userId);
        if (null == merchantInfo) {
            return this.convertToPromoteMoney(null);
        }
        MerchantUserAccountVO merchantUserAccountVO = this.merchantUserProAccountService.getUserProAccount(merchantInfo.getId());
        return this.convertToPromoteMoney(merchantUserAccountVO);
    }

    @Override
    public List<MerchantMarqueeDTO> getMerchantMarquee() {
        ArrayList<MerchantMarqueeDTO> resultList = new ArrayList<MerchantMarqueeDTO>(10);
        List listMerchantInfo = this.merchantInfoMapper.getLimitTen();
        if (CollectionUtils.isEmpty((Collection)listMerchantInfo) || listMerchantInfo.size() < 10) {
            Integer leftNum = 10 - (CollectionUtils.isEmpty((Collection)listMerchantInfo) ? 0 : listMerchantInfo.size());
            List userList = (List)this.userFeignService.getVirtualUserList(leftNum).getBody();
            for (UserInfoDTO userInfoDTO : userList) {
                resultList.add(MerchantMarqueeDTO.builder().headImg(userInfoDTO.getHeadImg()).name(userInfoDTO.getNickname().length() > 3 ? userInfoDTO.getNickname().substring(0, 2) + "***" : userInfoDTO.getNickname().substring(0, 1) + "***").build());
            }
        }
        listMerchantInfo.forEach(merchantInfo -> resultList.add(this.convertInfoToDto((MerchantInfo)merchantInfo)));
        return resultList;
    }

    private MerchantMarqueeDTO convertInfoToDto(MerchantInfo merchantInfo) {
        return MerchantMarqueeDTO.builder().headImg(merchantInfo.getLogo()).name(merchantInfo.getMerchantName().substring(0, 1) + "***").build();
    }

    private UserPromoteMoneyDTO convertToPromoteMoney(MerchantUserAccountVO userAccountVO) {
        UserPromoteMoneyDTO entity = new UserPromoteMoneyDTO();
        if (null == userAccountVO) {
            BigDecimal zero = new BigDecimal("0");
            entity.setLeftPromoteMoney(zero);
            entity.setUsePromoteMoney(zero);
            entity.setPromoteMoney(zero);
            entity.setTotalPromoteMoney(zero);
        } else {
            entity.setLeftPromoteMoney(userAccountVO.getAbleProCash());
            entity.setUsePromoteMoney(userAccountVO.getConsumeProCash());
            entity.setPromoteMoney(userAccountVO.getAbleProCash());
            entity.setTotalPromoteMoney(userAccountVO.getTotalProCash());
        }
        return entity;
    }

    public PromoteServiceImpl(MerchantInfoMapper merchantInfoMapper, MerchantUserProAccountService merchantUserProAccountService, UserFeignService userFeignService, MerchantCategoryMapper merchantCategoryMapper, MerchantUserPromotionFlowMapper merchantUserPromotionFlowMapper, MerchantProperties merchantProperties) {
        this.merchantInfoMapper = merchantInfoMapper;
        this.merchantUserProAccountService = merchantUserProAccountService;
        this.userFeignService = userFeignService;
        this.merchantCategoryMapper = merchantCategoryMapper;
        this.merchantUserPromotionFlowMapper = merchantUserPromotionFlowMapper;
        this.merchantProperties = merchantProperties;
    }
}

