/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.invite.processor;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.merchant.dto.TopicFacadeVO;
import com.bxm.localnews.merchant.entity.UserInviteHistoryEntity;
import com.bxm.localnews.merchant.service.NewsIntegrationService;
import com.bxm.localnews.merchant.service.invite.InviteProcessorContext;
import com.bxm.localnews.merchant.service.invite.InviteTypeProcessor;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TopicInviteTypeProcessor
implements InviteTypeProcessor {
    private final NewsIntegrationService newsIntegrationService;

    @Autowired
    public TopicInviteTypeProcessor(NewsIntegrationService newsIntegrationService) {
        this.newsIntegrationService = newsIntegrationService;
    }

    @Override
    public String obtainTitle(InviteProcessorContext context) {
        if (context.getRelationId() == null) {
            return "";
        }
        TopicFacadeVO topic = this.newsIntegrationService.getTopicById(context.getRelationId());
        if (StringUtils.isBlank((CharSequence)topic.getTitle())) {
            return "";
        }
        return topic.getTitle();
    }

    @Override
    public InviteTypeEnum support() {
        return InviteTypeEnum.TOPIC;
    }

    @Override
    public String decorateTitle(UserInviteHistoryEntity inviteHistory) {
        if (StringUtils.isBlank((CharSequence)inviteHistory.getRelationTitle())) {
            return "\u5176\u4ed6\u9080\u8bf7";
        }
        return "\u5206\u4eab\u7684\u300a" + inviteHistory.getRelationTitle() + "\u300b\u8bdd\u9898\u9080\u8bf7";
    }
}

