/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.service.stream;

import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.merchant.common.event.MessageDeleteForumDTO;
import com.bxm.localnews.merchant.common.event.ShareActionEvent;
import com.bxm.localnews.merchant.common.event.ShareForumActionEvent;
import com.bxm.localnews.merchant.service.count.MerchantPageCollectService;
import com.bxm.localnews.merchant.service.members.MerchantContentRecordService;
import com.bxm.localnews.user.enums.AppConst;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.StreamListener;
import org.springframework.stereotype.Component;

@Component
public class MessageSubscribe {
    private static final Logger log = LoggerFactory.getLogger(MessageSubscribe.class);
    @Autowired
    private MerchantPageCollectService merchantPageCollectService;
    @Autowired
    private MerchantContentRecordService merchantContentRecordService;

    @StreamListener(value="shareInput")
    public void consumeShareInfoAction(ShareActionEvent actionEvent) {
        this.merchantPageCollectService.shareContent(actionEvent.getTargetId(), actionEvent.getUserId(), InviteTypeEnum.NEWS);
    }

    @StreamListener(value="shareForumInput")
    public void consumeShareInfoAction(ShareForumActionEvent actionEvent) {
        this.merchantPageCollectService.shareContent(actionEvent.getTargetId(), actionEvent.getUserId(), InviteTypeEnum.FORUM);
    }

    @StreamListener(value="deleteForumInput")
    public void consumeDeleteForumAction(MessageDeleteForumDTO messageDeleteForumDTO) {
        if (Objects.equals(messageDeleteForumDTO.getStatus(), AppConst.DISALBE)) {
            this.merchantContentRecordService.updateStatus(messageDeleteForumDTO.getId(), messageDeleteForumDTO.getStatus().byteValue());
        }
    }
}

