/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.merchant.timer;

import com.bxm.localnews.merchant.domain.MerchantInfoMapper;
import com.bxm.localnews.merchant.dto.account.BossTodayAccountDTO;
import com.bxm.localnews.merchant.param.account.MerchantBossTodayCountParam;
import com.bxm.localnews.merchant.service.PushIntegrationService;
import com.bxm.localnews.merchant.service.account.boss.BossAccountService;
import com.bxm.localnews.merchants.vo.MerchantInfo;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import java.math.RoundingMode;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ManagementTodayTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(ManagementTodayTask.class);
    @Resource
    private BossAccountService bossAccountService;
    @Resource
    private MerchantInfoMapper merchantInfoMapper;
    @Autowired
    private PushIntegrationService pushIntegrationService;

    protected ReturnT<String> service(String s) {
        List allMerchant = this.merchantInfoMapper.queryVipMerchantList();
        if (allMerchant.isEmpty()) {
            return ReturnT.SUCCESS;
        }
        for (MerchantInfo merchantInfo : allMerchant) {
            MerchantBossTodayCountParam param = new MerchantBossTodayCountParam();
            param.setMerchantId(merchantInfo.getId());
            BossTodayAccountDTO info = this.bossAccountService.accountToday(param);
            String content = "\u4eca\u65e5\u5e97\u94fa\u8bbf\u5ba2\u6570:" + info.getTodayUV() + ",\u8ba2\u5355\u6570:" + info.getTodayOrders() + ",\u6536\u76ca" + info.getTodayAmount().setScale(2, RoundingMode.HALF_UP) + "\u5143";
            if (log.isDebugEnabled()) {
                log.debug("\u7ecf\u8425\u65e5\u62a5-merchantId \uff1b{}", (Object)merchantInfo.getId());
            }
            this.pushIntegrationService.pushBossEveryDayManagement(merchantInfo.getId(), merchantInfo.getUserId(), "\u5e97\u94fa\u7ecf\u8425\u65e5\u62a5", content);
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "\u6bcf\u5929\u591c\u91cc10\u70b9\u7ed9\u5546\u5bb6\u7ecf\u8425\u65e5\u62a5\u63a8\u9001";
    }

    public String cron() {
        return "0 0 22 * * ?";
    }
}

