package com.bxm.localnews.merchants.facade.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel(description = "前台店铺基本信息入参")
public class MerchantInfoParam extends MerchantIntoApplyParam {
    @ApiModelProperty(value = "店铺头图的json数组字符串", required = true)
    private String headPics;

    @ApiModelProperty("logo图片地址")
    private String logo;

    @ApiModelProperty("商户一句话描述")
    private String des;

    @ApiModelProperty(value = "店铺简称", required = true)
    private String shortName;

    @ApiModelProperty(value = "联系人名称", required = true)
    private String manageName;

    @ApiModelProperty(value = "开放时间 0: 全天开放 1: 指定时间开放", required = true)
    private Integer openType;

    @ApiModelProperty("营业开始时间 0000 为00:00")
    private String openTime;

    @ApiModelProperty("营业结束时间 0000 为00:00")
    private String closeTime;

    @ApiModelProperty("相册图片地址的json数组集合")
    private String album;

    @ApiModelProperty("店铺详情描述")
    private String detailContent;
}
