package com.bxm.localnews.message.constant;

import com.bxm.newidea.component.tools.NumberUtils;

/**
 * 推送消息
 */
public enum MessageEnum {

    SYSTEM_MSG(0, "系统公告"),
    ORDINARY_MSG(1, "消息"),
    ACCEPT_APPRENTICE(2, "收取徒弟"),
    PROMOTION(3, "晋升"),
    MONEY_CHANGE_NOTICE(4, "零钱变动通知"),
    ADD_DISCIPLE(6, "收取徒孙奖励"),
    WAKE_APPRENTICE(7, "唤醒"),
    FIRST_RECRUIT(8, "首次收徒"),
    NEWS(9, "新闻"),
    RED_PACKET_AWARD(10, "红包拉新收徒奖励");

    private int type;

    private String desc;

    MessageEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getMessageEnumByType(int type) {
        for (MessageEnum messageEnum : MessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getDesc();
            }
        }
        return null;
    }

    public static String getMessageEnumByType(String type) {
        return getMessageEnumByType(NumberUtils.parseToInt(type));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
