package com.bxm.localnews.message.constant;

import com.bxm.localnews.common.constant.AppConst;

/**
 * Created by Arei on 2018/10/11.
 * 短信模版常量类，存放包括短信模版的所有配置（内容，发送次数限制，模版类型，参数个数等）
 *
 * @author Arei
 */
public enum SmsTemplateEnum {
    /**
     * 登录模版
     */
    LOGIN("您本次登录的验证码为{}，有效期为10分钟，请勿泄露给他人！", 1, SmsTemplateTypeEnum.V_CODE),
    /**
     * 注册模版
     */
    REGISTER("尊敬的用户，您的注册验证码为{}", 1, SmsTemplateTypeEnum.V_CODE),
    /**
     * 绑定号码模版
     */
    BINDING_PHONE("您正在绑定手机号码，验证码为{}，有效期为10分钟，请勿泄露给他人！", 1, SmsTemplateTypeEnum.V_CODE),
    /**
     * 重置密码模版
     */
    RESET_PWD("尊敬的用户，您正在进行重置密码，验证码是{}，请勿泄露！", 1, SmsTemplateTypeEnum.V_CODE),
    /**
     * 唤醒用户模版
     */
    AWAKE("您已经很久没来本地万事通领金币兑换零钱了呢,赶快打开APP继续赚零花钱吧!点击：{}", 1, SmsTemplateTypeEnum.NORMAL),
    /**
     * 普通验证码（商户，蓝领）
     */
    NORMAL_V_CODE("您的验证码:{}，请不要告诉他人。", 1, SmsTemplateTypeEnum.V_CODE);

    /**
     * 短信内容
     */
    private String content;

    /**
     * 模版参数个数，用来校验调用者传参个数是否准确
     */
    private int paramsNum;

    /**
     * 短信模版类型（验证码/其他...）
     */
    private SmsTemplateTypeEnum type;

    SmsTemplateEnum(String content,
                    int paramsNum,
                    SmsTemplateTypeEnum type) {

        this.content = content;
        this.paramsNum = paramsNum;
        this.type = type;
    }

    /**
     * 兼容原来的短信模版常量类
     *
     * @param type
     * @return
     */
    public static SmsTemplateEnum getTemplateByType(Byte type) {
        SmsTemplateEnum templateEnum = null;
        switch (type) {
            case AppConst.SMS_TPL.VCODE_TYPE_LOGIN:
                templateEnum = SmsTemplateEnum.LOGIN;
                break;
            case AppConst.SMS_TPL.VCODE_TYPE_BIND_PHONE:
                templateEnum = SmsTemplateEnum.BINDING_PHONE;
                break;
            case AppConst.SMS_TPL.VCODE_TYPE_RETRIEVE_PWD:
                templateEnum = SmsTemplateEnum.RESET_PWD;
                break;
            case AppConst.SMS_TPL.VCODE_TYPE_REGISTER:
                templateEnum = SmsTemplateEnum.REGISTER;
                break;
            case AppConst.SMS_TPL.MERCHANT_CODE:
                templateEnum = SmsTemplateEnum.NORMAL_V_CODE;
        }
        return templateEnum;
    }

    public String getContent() {
        return content;
    }

    public int getParamsNum() {
        return paramsNum;
    }

    /**
     * 校验模版是否是验证码类型模版，用于调用者调用发送验证码类短信的方法的校验
     *
     * @return
     */
    public boolean isVCodeType() {
        return this.type == SmsTemplateTypeEnum.V_CODE;
    }
}
