package com.bxm.localnews.message.vo;

import java.util.Date;

import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "用户通知消息")
public class Message extends BaseBean {

    @ApiModelProperty("消息ID")
    private Integer id;

    @ApiModelProperty(hidden = true)
    private Long userId;

    @ApiModelProperty("消息图标")
    private String icon;

    @ApiModelProperty("消息标题")
    private String title;

    @ApiModelProperty("消息内容")
    private String content;

    @ApiModelProperty(hidden = true)
    private Byte status;

    @ApiModelProperty("消息类型 0：系统消息  1 : 通知消息,9新闻，" +
            "11参加活动成功，12活动开奖，13活动中奖，14奖品过期，15任务完成（日常/新手）")
    private String msgType;

    @ApiModelProperty("发送时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty(hidden = true)
    private Date updateTime;

    @ApiModelProperty("消息状态 0：未读  1：已读  2：删除")
    private Byte readStatus;

    @ApiModelProperty(hidden = true)
    private String sendTypeStr;

    @ApiModelProperty(hidden = true)
    private String sendStateStr;

    @ApiModelProperty(hidden = true)
    private String typeStr;

    @ApiModelProperty(hidden = true)
    private String phones;

    @ApiModelProperty(hidden = true)
    private String sendTime = "";

    @ApiModelProperty(hidden = true)
    private Integer sendType;

    @ApiModelProperty(hidden = true)
    private Integer sendState;

    @ApiModelProperty("跳转地址")
    private String linkUrl;

    @ApiModelProperty("跳转参数")
    private String linkParam;

    public Message() {
    }

    public Message(Long userId, Byte status) {
        this.userId = userId;
        this.status = status;
    }

    public Message(Long userId, String title, String content, String msgType) {
        this.userId = userId;
        this.title = title;
        this.content = content;
        this.msgType = msgType;
    }

    public Message(Long userId, String icon, String title, String content, String msgType) {
        this.userId = userId;
        this.icon = icon;
        this.title = title;
        this.content = content;
        this.msgType = msgType;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getLinkParam() {
        return linkParam;
    }

    public void setLinkParam(String linkParam) {
        this.linkParam = linkParam;
    }

    public Byte getReadStatus() {
        return this.readStatus;
    }

    public void setReadStatus(Byte readStatus) {
        this.readStatus = readStatus;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column a_message.id
     *
     * @return the value of a_message.id
     */
    public Integer getId() {
        return this.id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column a_message.id
     *
     * @param id the value for a_message.id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column a_message.user_id
     *
     * @return the value of a_message.user_id
     */
    public Long getUserId() {
        return this.userId;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column a_message.user_id
     *
     * @param userId the value for a_message.user_id
     */
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column a_message.title
     *
     * @return the value of a_message.title
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column a_message.title
     *
     * @param title the value for a_message.title
     */
    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column a_message.content
     *
     * @return the value of a_message.content
     */
    public String getContent() {
        return this.content;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column a_message.content
     *
     * @param content the value for a_message.content
     */
    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column a_message.status
     *
     * @return the value of a_message.status
     */
    public Byte getStatus() {
        return this.status;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column a_message.status
     *
     * @param status the value for a_message.status
     */
    public void setStatus(Byte status) {
        this.status = status;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column a_message.msg_type
     *
     * @return the value of a_message.msg_type
     */
    public String getMsgType() {
        return this.msgType;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column a_message.msg_type
     *
     * @param msgType the value for a_message.msg_type
     */
    public void setMsgType(String msgType) {
        this.msgType = msgType == null ? null : msgType.trim();
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column a_message.add_time
     *
     * @return the value of a_message.add_time
     */
    public Date getAddTime() {
        return this.addTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column a_message.add_time
     *
     * @param addTime the value for a_message.add_time
     */
    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method returns the value of the database column a_message.update_time
     *
     * @return the value of a_message.update_time
     */
    public Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * This method was generated by MyBatis Generator.
     * This method sets the value of the database column a_message.update_time
     *
     * @param updateTime the value for a_message.update_time
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getSendTypeStr() {
        return this.sendTypeStr;
    }

    public void setSendTypeStr(String sendTypeStr) {
        this.sendTypeStr = sendTypeStr;
    }

    public String getSendStateStr() {
        return this.sendStateStr;
    }

    public void setSendStateStr(String sendStateStr) {
        this.sendStateStr = sendStateStr;
    }

    public String getTypeStr() {
        return this.typeStr;
    }

    public void setTypeStr(String typeStr) {
        this.typeStr = typeStr;
    }

    public String getPhones() {
        return this.phones;
    }

    public void setPhones(String phones) {
        this.phones = phones;
    }

    public String getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(String sendTime) {
        this.sendTime = sendTime;
    }

    public Integer getSendType() {
        return this.sendType;
    }

    public void setSendType(Integer sendType) {
        this.sendType = sendType;
    }

    public Integer getSendState() {
        return this.sendState;
    }

    public void setSendState(Integer sendState) {
        this.sendState = sendState;
    }

}
