package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.msg.dto.MessageTypeDTO;
import com.bxm.localnews.msg.param.MsgCenterParam;
import com.bxm.localnews.msg.service.UserMessageService;
import com.bxm.newidea.component.annotations.ApiVersion;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "5-04 消息中心相关接口")
@RestController
@RequestMapping("{version}/msg/center")
public class MsgCenterController {

    private UserMessageService userMessageService;

    @Autowired
    public MsgCenterController(UserMessageService userMessageService) {
        this.userMessageService = userMessageService;
    }

    @ApiOperation(value = "5-04-1 [v1]获取消息中心列表")
    @GetMapping("list")
    @ApiVersion(1)
    public Json<MessageTypeDTO> getMessageList(MsgCenterParam param) {
        return ResultUtil.genSuccessResult(this.userMessageService.getMessageType(param.getAreaCode(),
                param.getUserId(),
                param));
    }
}

