package com.bxm.localnews.msg.controller;

import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.mq.common.constant.PlatformTypeEnum;
import com.bxm.localnews.msg.integration.BizLogIntegrationService;
import com.bxm.localnews.msg.service.MessageGroupCounterService;
import com.bxm.localnews.msg.service.MessageGroupService;
import com.bxm.localnews.msg.service.UserTokenService;
import com.bxm.localnews.msg.vo.MsgGroupPushCounterBean;
import com.bxm.localnews.msg.vo.MsgUserTokenBean;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "5-03 用户消息列表", description = "推送消息后的相关回调操作")
@RestController
@RequestMapping("api/public/push/message")
@Slf4j
public class PushMessageController {

    private final MessageGroupCounterService messageGroupCounterService;

    private final UserTokenService userTokenService;

    private final BizLogIntegrationService bizLogIntegrationService;

    private MessageGroupService messageGroupService;

    @Autowired
    public PushMessageController(MessageGroupCounterService messageGroupCounterService,
                                 UserTokenService userTokenService,
                                 BizLogIntegrationService bizLogIntegrationService) {
        this.messageGroupCounterService = messageGroupCounterService;
        this.userTokenService = userTokenService;
        this.bizLogIntegrationService = bizLogIntegrationService;
    }

    private MessageGroupService getMessageGroupService() {
        if (null == messageGroupService) {
            messageGroupService = SpringContextHolder.getBean(MessageGroupService.class);
        }
        return messageGroupService;
    }

    @ApiOperation(value = "5-03-1 更新用户查阅消息后的状态", notes = "用户查看推送消息后反馈查看结果")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "messageId", value = "消息id", required = true)
    })
    @PostMapping(value = "checked")
    public ResponseJson updateById(@RequestParam(value = "userId") Long userId,
                                   @RequestParam(value = "messageId") Long messageId) {

        if (getMessageGroupService().isGroupMsg(messageId)) {
            List<MsgUserTokenBean> userToken = userTokenService.loadToken(userId);

            boolean hit = false;

            for (MsgUserTokenBean tokenBean : userToken) {
                PlatformTypeEnum platform = PlatformTypeEnum.getByCode(tokenBean.getType());

                if (platform.isApp()) {
                    hit = true;
                    messageGroupCounterService.addCounter(MsgGroupPushCounterBean.builder()
                            .callback(1)
                            .groupMsgId(messageId)
                            .pushType(platform.getCode())
                            .build());

                    PointReportParam reportParam = PointReportParam.build().e("3034").ev("126")
                            .put("uid", String.valueOf(tokenBean.getUserId()))
                            .put("nid", String.valueOf(messageId))
                            .put("type", String.valueOf(tokenBean.getPlatform()))
                            .put("num", "2");
                    bizLogIntegrationService.point(reportParam);
                }
            }

            if (!hit) {
                log.info("用户[{}]点击消息回调时找不到对应的token，消息ID为[{}]", userId, messageId);
            }
        } else {
            log.info("非运营消息点击回调，userId:{},messageId:{}", userId, messageId);
        }

        return ResponseJson.ok().build();
    }
}
