/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.common.constant;

import com.bxm.localnews.mq.common.constant.MessageBehaviorEnum;
import com.bxm.newidea.component.tools.NumberUtils;

public enum PushMessageEnum {
    SYSTEM_MSG(0, "\u7cfb\u7edf\u516c\u544a", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE),
    ORDINARY_MSG(1, "\u63d0\u793a\u6d88\u606f", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE),
    NEWS(9, "\u65b0\u95fb", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    PARTICIPATE_PRIVILEGE_SUCCESS(11, "\u53c2\u52a0\u6d3b\u52a8\u6210\u529f", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    PRIVILEGE_OPEN_PRIZE(12, "\u6d3b\u52a8\u5f00\u5956", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    PRIVILEGE_WINNING(13, "\u6d3b\u52a8\u4e2d\u5956", MessageBehaviorEnum.JUMP, Boolean.FALSE),
    TASK_COMPLETED(15, "\u4efb\u52a1\u5b8c\u6210\uff08\u65e5\u5e38/\u65b0\u624b\uff09", MessageBehaviorEnum.UN_JUMP, Boolean.TRUE),
    NEW_MERCHANT(16, "\u5546\u5bb6\u63d0\u4ea4\u4fe1\u606f\u6210\u529f", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE),
    MERCHANT_VERIFY(18, "\u5546\u5bb6\u5ba1\u6838\u5931\u8d25", MessageBehaviorEnum.UN_JUMP, Boolean.FALSE);

    private int type;
    private String desc;
    private MessageBehaviorEnum behavior;
    private Boolean silence;

    private PushMessageEnum(int type, String desc, MessageBehaviorEnum behavior, Boolean silence) {
        this.type = type;
        this.desc = desc;
        this.behavior = behavior;
        this.silence = silence;
    }

    public static String getMessageDescByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum.getDesc();
        }
        return null;
    }

    public static String getMessageDescByType(String type) {
        return PushMessageEnum.getMessageDescByType(NumberUtils.parseToInt((String)type));
    }

    public static MessageBehaviorEnum getMessageBehaviorByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum.getBehavior();
        }
        return null;
    }

    public static Boolean getMessageSilenceByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() != type) continue;
            return messageEnum.getSilence();
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public MessageBehaviorEnum getBehavior() {
        return this.behavior;
    }

    public Boolean getSilence() {
        return this.silence;
    }
}

