/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.common.model.dto;

import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.newidea.component.vo.BaseBean;
import java.util.List;

public class PushMessage
extends BaseBean {
    private String title;
    private String content;
    private String userId;
    private boolean mute = false;
    private PushSoundEnum sound = PushSoundEnum.DEFAULT_SOUND;
    private TemplateTypeEnum type = TemplateTypeEnum.TRANSMISSION;
    private PushPayloadInfo payloadInfo = PushPayloadInfo.build();
    private boolean persistence = true;
    private List<String> userIds;

    private PushMessage(String title, String content) {
        this.title = title;
        this.content = content;
    }

    private PushMessage() {
    }

    public static PushMessage build(String title, String content) {
        return new PushMessage(title, content);
    }

    public static PushMessage build(String title, String content, Long userId) {
        return new PushMessage(title, content).setUserId(userId);
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public PushMessage setUserIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public PushMessage setPersistence(boolean persistence) {
        this.persistence = persistence;
        return this;
    }

    public PushSoundEnum getSound() {
        return this.sound;
    }

    public PushMessage setSound(PushSoundEnum sound) {
        this.sound = sound;
        return this;
    }

    public boolean isMute() {
        return this.mute;
    }

    public PushMessage setMute(boolean mute) {
        this.mute = mute;
        return this;
    }

    public TemplateTypeEnum getType() {
        return this.type;
    }

    @Deprecated
    public PushMessage setType(TemplateTypeEnum type) {
        this.type = type;
        return this;
    }

    public String getAlias() {
        return this.userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public PushMessage setUserId(Long userId) {
        this.userId = null == userId ? "" : userId.toString();
        return this;
    }

    public PushMessage setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public PushMessage setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public PushMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public PushPayloadInfo getPayloadInfo() {
        if (null == this.payloadInfo) {
            this.payloadInfo = PushPayloadInfo.build();
        }
        return this.payloadInfo;
    }

    public PushMessage setPayloadInfo(PushPayloadInfo payloadInfo) {
        this.payloadInfo = null == payloadInfo ? PushPayloadInfo.build() : payloadInfo;
        this.syncPayloadInfo();
        return this;
    }

    public PushMessage syncPayloadInfo() {
        this.payloadInfo.setTitle(this.title);
        this.payloadInfo.setContent(this.content);
        this.payloadInfo.setSound(this.mute ? "" : this.sound.getAndriodSound());
        return this;
    }
}

