package com.bxm.localnews.mq.common.constant;

import com.bxm.newidea.component.tools.NumberUtils;

import static com.bxm.localnews.mq.common.constant.MessageBehaviorEnum.JUMP;
import static com.bxm.localnews.mq.common.constant.MessageBehaviorEnum.UN_JUMP;


/**
 * 推送消息
 */
public enum PushMessageEnum {

    /**
     * 新版本不根据枚举定义消息类型
     * 但是需要跳转的话，还是需要定义MessageBehaviorEnum 所以这里进行定义默认的JUMP类型
     * 根据这个类型，客户端会执行跳转协议这个操作
     */
    JUMP_TYPE(105, "新版本推送需要跳转的类型", JUMP, Boolean.FALSE),

    // 下面都不允许再使用

    /**
     * 系统公告
     */
    @Deprecated
    SYSTEM_MSG(0, "系统公告", UN_JUMP, Boolean.FALSE),
    @Deprecated
    ORDINARY_MSG(1, "提示消息", UN_JUMP, Boolean.FALSE),
    @Deprecated
    INTERACTION_MSG(5, "互动消息", UN_JUMP, Boolean.FALSE),
    @Deprecated
    POST(8, "帖子", JUMP, Boolean.FALSE),
    @Deprecated
    NEWS(9, "新闻", JUMP, Boolean.FALSE),
    @Deprecated
    OPEN_URL(10, "打开链接", JUMP, Boolean.FALSE),
    @Deprecated
    PARTICIPATE_PRIVILEGE_SUCCESS(11, "参加活动成功", JUMP, Boolean.FALSE),
    @Deprecated
    PRIVILEGE_OPEN_PRIZE(12, "活动开奖", JUMP, Boolean.FALSE),
    @Deprecated
    PRIVILEGE_WINNING(13, "活动中奖", JUMP, Boolean.FALSE),
    @Deprecated
    TASK_COMPLETED(15, "任务完成（日常/新手）", UN_JUMP, Boolean.TRUE),
    @Deprecated
    NEW_MERCHANT(16, "商家提交信息成功", UN_JUMP, Boolean.FALSE),
    @Deprecated
    MERCHANT_VERIFY(18, "商家审核失败", UN_JUMP, Boolean.FALSE),
    @Deprecated
    VIP_FRIEND_HELP(30, "用户激活vip时好友助力", JUMP, Boolean.FALSE),
    @Deprecated
    VIP_ACTIVATION_SUCCESS(31, "用户激活vip", UN_JUMP, Boolean.FALSE),
    @Deprecated
    VIP_NOT_ACTIVATION(32, "未激活VIP", JUMP, Boolean.FALSE),
    @Deprecated
    VIP_CONTINUE_ACTIVATION(33, "继续激活VIP", JUMP, Boolean.FALSE),
    @Deprecated
    VIP_ACTIVATION(34, "已激活VIP", JUMP, Boolean.FALSE),
    @Deprecated
    NEWS_REPLY(50, "新闻回复", JUMP, Boolean.FALSE),
    @Deprecated
    NEWS_LIKE(51, "新闻点赞", JUMP, Boolean.FALSE),
    @Deprecated
    POST_REPLY(52, "帖子回复", JUMP, Boolean.FALSE),
    @Deprecated
    POST_LIKE(53, "帖子点赞", JUMP, Boolean.FALSE),
    @Deprecated
    POST_REVIEW_PASS(54, "帖子审核通过", JUMP, Boolean.FALSE),
    @Deprecated
    ESSENCE_POST(55, "精华帖通知", JUMP, Boolean.FALSE),
    @Deprecated
    CASH_POST(56, "现金帖", JUMP, Boolean.FALSE),
    @Deprecated
    BELONG_POST_REPLY(57, "帖子所属人回复", JUMP, Boolean.FALSE),
    @Deprecated
    BELONG_POST_LIKE(58, "帖子所属人点赞", JUMP, Boolean.FALSE),
    @Deprecated
    UPDATE_GOLD(59, "金币变动(不发送推送)", JUMP, Boolean.FALSE),

    @Deprecated
    FAIL_WITHDRAW(60, "您的微信号未实名认证，提现失败", JUMP, Boolean.FALSE),
    @Deprecated
    ADD_CASH(61, "新增赏金", JUMP, Boolean.FALSE),
    @Deprecated
    SUCCESS_WITHDRAW(62, "您的提现已成功打款", JUMP, Boolean.FALSE),
    @Deprecated
    RED_PACKET_PASS(70, "创建的红包审核通过", JUMP, Boolean.FALSE),
    @Deprecated
    RED_PACKET_NOT_PASS(71, "创建的红包审核不通过", JUMP, Boolean.FALSE),
    @Deprecated
    RECEIVE_RED_PACKET(72, "红包已被人领取", JUMP, Boolean.FALSE),
    @Deprecated
    REA_PACKET_FINISH(73, "红包领取完毕", JUMP, Boolean.FALSE),
    @Deprecated
    FORWARDING(80, "转发通知", JUMP, Boolean.FALSE),
    @Deprecated
    INVITE(81, "邀请通知", JUMP, Boolean.FALSE),
    @Deprecated
    POST_ADD_RECOMMAND(82, "帖子加入推荐库通知用户", JUMP, Boolean.FALSE),
    @Deprecated
    BROKE_POST(83, "爆料帖", JUMP, Boolean.FALSE),
    @Deprecated
    ADD_FUNS(98, "新增粉丝", JUMP, Boolean.TRUE),
    @Deprecated
    IM_MESSAGE(99, "即时通讯消息", JUMP, Boolean.TRUE),
    @Deprecated
    IM_CHAT_ROOM_TIMING_RED_PACKET_MESSAGE(100, "聊天室定时红包提醒", JUMP, Boolean.FALSE),
    @Deprecated
    UNLOCK_PICK_REDPACKAGE(101, "解锁聊天室抢红包权限", JUMP, Boolean.FALSE),



    /**
     * ===============================================
     * 用户事件已经迁移至单独的枚举类：{@link UserEventEnum}
     * 注意不要和用户事件的code值重复定义
     * ===============================================
     */
    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    USER_ACCOUNT_ENVET(90, "用户金额变动", JUMP, Boolean.FALSE),

    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    USER_UN_READ_MSG(91, "用户未读消息数量", JUMP, Boolean.FALSE),

    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    APPLET_USER_UN_READ_MSG(92, "用户未读消息数量", JUMP, Boolean.FALSE),

    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    TASK_COMPLETE_EVENT(93, "任务完成提示", JUMP, Boolean.FALSE),

    /**
     * @deprecated {@link UserEventEnum}
     */
    @Deprecated
    IM_UNBLOCK(94, "解除用户封禁", JUMP, Boolean.TRUE),

    @Deprecated
    COMMODITY_PURCHASE_ORDER(102, "自购订单跟单成功", JUMP, Boolean.FALSE),
    @Deprecated
    COMMODITY_SHARE_ORDER(103, "分享订单跟单成功", JUMP, Boolean.FALSE),
    @Deprecated
    SUPERIOR_ORDER(104, "下级用户跟单成功给上级推送", JUMP, Boolean.FALSE),

    ;

    private int type;

    private String desc;

    /**
     * 是否需要跳转（会影响在消息列表中显示的消息是否显示查看详情）
     */
    private MessageBehaviorEnum behavior;

    /**
     * 是否静默推送（无通知栏）
     */
    private Boolean silence;

    PushMessageEnum(int type, String desc, MessageBehaviorEnum behavior, Boolean silence) {
        this.type = type;
        this.desc = desc;
        this.behavior = behavior;
        this.silence = silence;
    }

    public static String getMessageDescByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getDesc();
            }
        }
        return null;
    }

    public static PushMessageEnum getMessageByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum;
            }
        }
        return null;
    }

    public static String getMessageDescByType(String type) {
        return getMessageDescByType(NumberUtils.parseToInt(type));
    }

    public static MessageBehaviorEnum getMessageBehaviorByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getBehavior();
            }
        }
        return null;
    }

    public static Boolean getMessageSilenceByType(int type) {
        for (PushMessageEnum messageEnum : PushMessageEnum.values()) {
            if (messageEnum.getType() == type) {
                return messageEnum.getSilence();
            }
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public MessageBehaviorEnum getBehavior() {
        return behavior;
    }

    public void setBehavior(MessageBehaviorEnum behavior) {
        this.behavior = behavior;
    }

    public Boolean getSilence() {
        return silence;
    }

    public void setSilence(Boolean silence) {
        this.silence = silence;
    }
}
