package com.bxm.localnews.msg.param;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.PageParam;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * Created by Arei on 2018/10/25.
 */
@ApiModel(description = "消息参数")
public class MessageListParam extends PageParam implements IUserIdSharding {
    @NotNull
    private Long userId;

    @ApiModelProperty("地区编码")
    private String areaCode;

    @ApiModelProperty("消息类型：INTERACTION(互动消息)、SYSTEM(系统通知)、NEWS(热闻)、BALANCE(余额)、COMMENT(评论)、LIKE(点赞)、SHARE(分享)、INVITE(邀请)")
    private String messageType;

    @ApiModelProperty(value = "消息类型参数列表", hidden = true)
    private List<String> msgTypeList = Lists.newArrayList();

    @Override
    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getMessageType() {
        return messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public List<String> getMsgTypeList() {
        return msgTypeList;
    }

    public void setMsgTypeList(List<String> msgTypeList) {
        this.msgTypeList = msgTypeList;
    }
}
