package com.bxm.localnews.msg.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author zhaoyadong 2019/4/1 15:46
 * @desc
 */
@ApiModel(description = "消息类型")
public class MessageType {

    @ApiModelProperty("所属类型：ype:INTERACTION(互动消息)、 SYSTEM(系统通知)、NEWS(热闻)、BALANCE(余额)")
    private String messageType;

    @ApiModelProperty(value = "类型名称：标题（例如：系统通知）")
    private String title;

    @ApiModelProperty("图片:对应类型的图标")
    private String img;

    @ApiModelProperty("描述:该类型最新的消息内容标题")
    private String description;

    @ApiModelProperty("最后一条的消息时间，格式：根据需求返回的时间字符串 例：YYYY-MM-dd")
    private String lastTime;

    @ApiModelProperty("未读消息数量 小于99直接显示，大于显示：99+，需要客户端自己控制显示")
    private Integer unreadNum;

    public String getMessageType() {
        return messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getImg() {
        return img;
    }

    public void setImg(String img) {
        this.img = img;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLastTime() {
        return lastTime;
    }

    public void setLastTime(String lastTime) {
        this.lastTime = lastTime;
    }

    public Integer getUnreadNum() {
        return unreadNum;
    }

    public void setUnreadNum(Integer unreadNum) {
        this.unreadNum = unreadNum;
    }
}
