package com.bxm.localnews.msg.domain;

import com.bxm.localnews.msg.vo.MsgGroupPushCounterBean;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

@Mapper
public interface MsgGroupPushCounterMapper {
    int deleteByPrimaryKey(Long id);

    int insert(MsgGroupPushCounterBean record);

    /**
     * 根据消息ID删除统计数据
     *
     * @param msgId 消息ID
     * @return 删除行数
     */
    int deleteByMsgId(Long msgId);

    MsgGroupPushCounterBean selectByPrimaryKey(Long id);

    /**
     * 增加统计数据，包括成功、失败、回调
     *
     * @param record 更新的原始数据，必须包含消息ID、累加数量的任意一个
     * @return 更新影响行数
     */
    int addCounter(MsgGroupPushCounterBean record);

    /**
     * 查询消息的统计数据
     *
     * @param msgId 消息ID
     * @return 不同平台的统计数据
     */
    List<MsgGroupPushCounterBean> getMesageCounter(Long msgId);
}