package com.bxm.localnews.msg.config;

import com.bxm.localnews.msg.facade.*;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

/**
 * 只有在测试环境启用，防止粗心的调用方引入到正式环境
 *
 * @author liujia
 * @date 2020-07-13 17:56
 **/
@Configuration
@ConditionalOnClass(name = {"org.springframework.test.context.junit4.SpringRunner"})
public class MessageExposeMockConfiguration {

    @Bean
    @Primary
    public DingtalkFacadeService dingtalkFacadeService() {
        return new DingtalkFacadeServiceMock();
    }

    @Bean
    @Primary
    public MessageFacadeService messageFacadeService() {
        return new MessageFacadeServiceMock();
    }

    @Bean
    @Primary
    public PushFacadeService pushFacadeService() {
        return new PushFacadeServiceMock();
    }

    @Bean
    @Primary
    public UserEventFacadeService userEventFacadeServiceMock() {
        return new UserEventFacadeServiceMock();
    }


    @Bean
    @Primary
    public SmsFacadeService smsFacadeService() {
        return new SmsFacadeServiceMock();
    }

    ;
}
