package com.bxm.localnews.msg.facade;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.newidea.component.tools.RandomUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Primary;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@RequestMapping("/facade/msg/mock")
@Primary
@Component
public class MessageFacadeServiceMock implements MessageFacadeService {

    @Override
    public ResponseEntity<Boolean> addMsg(PushMessage pushMessage, Long userId) {
        log.info("添加用户消息：{}", JSON.toJSONString(pushMessage));
        return ResponseEntity.ok(true);
    }

    @Override
    public ResponseEntity<Map<String, Long>> getUnReadMessageNum(Long userId, String messageType) {
        HashMap<String, Long> result = Maps.newHashMap();
        result.put(messageType, RandomUtils.nextLong(1, 10));
        return ResponseEntity.ok(result);
    }
}