package com.bxm.localnews.msg.facade;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * @author liujia
 * @date 2020-07-15 22:40
 **/
@Slf4j
@Primary
@Component
@RequestMapping("/sms/mock")
public class SmsFacadeServiceMock implements SmsFacadeService {
    @Override
    public Boolean verifySmsCodeByType(Byte type, String phoneNo, String code) {
        log.debug("模拟短信发送,type:{},phoneNo:{},code:{}",
                type, phoneNo, code);
        return Boolean.TRUE;
    }

    @Override
    public SendSmsResult sendSmsByVCodeTemplate(SmsSupplyDTO smsSupplyDTO) {
        log.debug("模拟短信发送，固定返回成功，请求参数：{}", JSON.toJSONString(smsSupplyDTO));
        return SendSmsResult.build(true, "");
    }
}
