package com.bxm.localnews.msg.config;

import com.bxm.newidea.component.thread.NamedThreadFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.ThreadPoolExecutor;

/**
 * 消息服务暴露接口的相关实例初始化
 *
 * @author liujia
 * @date 2020-07-13 16:53
 **/
@Configuration
public class MsgExposeConfiguration {

    @Bean
    @ConditionalOnMissingBean(ThreadPoolTaskExecutor.class)
    public ThreadPoolTaskExecutor asyncTheadPoolExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(Runtime.getRuntime().availableProcessors() + 2);
        executor.setQueueCapacity(100000);
        executor.setMaxPoolSize(30);
        executor.setKeepAliveSeconds(10);
        executor.setRejectedExecutionHandler(new ThreadPoolExecutor.AbortPolicy());
        executor.setThreadFactory(new NamedThreadFactory("msg-expose"));

        executor.initialize();
        return executor;
    }
}
