package com.bxm.localnews.msg.facade.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.facade.PushFacadeService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author liujia
 * @date 2020-07-13 16:44
 **/
@Component
@Slf4j
public class PushFallbackFactory implements FallbackFactory<PushFacadeService> {
    @Override
    public PushFacadeService create(Throwable cause) {
        return new PushFacadeService() {
            @Override
            public void pushMsg(PushMessage message) {
                log.error("消息推送失败：[{}]", JSON.toJSONString(message));
                log.error(cause.getMessage(), cause);
            }
        };
    }
}
