package com.bxm.localnews.msg.facade.fallback;

import com.bxm.localnews.mq.common.model.dto.UserTokenParam;
import com.bxm.localnews.msg.facade.UserTokenFacadeService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UserTokenFallbackFactory implements FallbackFactory<UserTokenFacadeService> {
    @Override
    public UserTokenFacadeService create(Throwable cause) {
        return new UserTokenFacadeService() {
            @Override
            public void addToken(UserTokenParam param) {
                log.error("保存用户token信息失败，用户token信息:{}", param);
                log.error(cause.getMessage(), cause);
            }
        };
    }
}
