package com.bxm.localnews.msg.facade;

import com.bxm.localnews.mq.common.model.dto.MessageFilterInfo;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.facade.fallback.MessageFallbackFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * 用户消息中心相关接口调用
 *
 * @author liujia
 * @date 2020-07-13 17:15
 **/
@Api(tags = "5-90 用户消息列表", description = "获取用户的消息")
@FeignClient(value = "localnews-msg", fallbackFactory = MessageFallbackFactory.class, primary = false)
@RequestMapping("/facade/msg")
public interface MessageFacadeService {

    @ApiOperation(value = "5-90-2 添加用户消息")
    @PostMapping(value = "/add")
    ResponseEntity<Boolean> addMsg(@RequestBody PushMessage pushMessage, @RequestParam("userId") Long userId);

    @ApiOperation(value = "5-90-6 根据类别获取获取未读的消息数")
    @GetMapping("/unread-num")
    ResponseEntity<Map<String, Long>> getUnReadMessageNum(@RequestParam(value = "userId") Long userId, @RequestParam(value = "messageType") String messageType);

    @ApiOperation(value = "5-90-7 添加用户消息类型处理")
    @PostMapping(value = "/addMsgFilter")
    ResponseEntity<Boolean> addMsgFilter(@RequestBody MessageFilterInfo info);
}
