package com.bxm.localnews.msg.facade.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.MessageFilterInfo;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.facade.MessageFacadeService;
import com.google.common.collect.Maps;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 用户消息接口调用失败后的处理
 *
 * @author liujia
 * @date 2020-07-13 17:17
 **/
@Component
@Slf4j
public class MessageFallbackFactory implements FallbackFactory<MessageFacadeService> {

    @Override
    public MessageFacadeService create(Throwable cause) {
        return new MessageFacadeService() {
            @Override
            public ResponseEntity<Boolean> addMsg(PushMessage pushMessage, Long userId) {
                log.error("添加用户消息失败，用户ID:[{}],消息内容：[{}]", userId, JSON.toJSONString(pushMessage));
                log.error(cause.getMessage(), cause);
                return ResponseEntity.ok(false);
            }

            @Override
            public ResponseEntity<Map<String, Long>> getUnReadMessageNum(Long userId, String messageType) {
                log.error("获取用户未读消息数量失败，请求参数：{}-{}", userId, messageType);
                log.error(cause.getMessage(), cause);

                HashMap<String, Long> result = Maps.newHashMap();
                result.put(messageType, 0L);
                return ResponseEntity.ok(result);
            }

            @Override
            public ResponseEntity<Boolean> addMsgFilter(MessageFilterInfo info) {
                log.error("添加用户消息处理事件失败，用户ID:[{}],消息内容：[{}]", info.getUserId(), JSON.toJSONString(info));
                log.error(cause.getMessage(), cause);
                return ResponseEntity.ok(false);
            }
        };
    }
}
