package com.bxm.localnews.msg.facade.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.facade.UserEventFacadeService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 调用消息服务失败后的逻辑
 *
 * @author liujia
 * @date 2020-07-13 16:49
 **/
@Component
@Slf4j
public class UserEventFallbackFactory implements FallbackFactory<UserEventFacadeService> {
    @Override
    public UserEventFacadeService create(Throwable cause) {
        return new UserEventFacadeService() {
            @Override
            public void add(PushPayloadInfo payloadInfo) {
                log.error("调用消息服务失败，用户事件内容为：{}", JSON.toJSONString(payloadInfo));
                log.error(cause.getMessage(), cause);
            }
        };
    }
}
