package com.bxm.localnews.msg.facade;

import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSendParam;
import com.bxm.localnews.msg.facade.fallback.SmsFallbackFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

@Api(tags = "1-3 短信发送接口")
@FeignClient(value = "localnews-msg", fallbackFactory = SmsFallbackFactory.class, primary = false)
@RequestMapping("/sms")
public interface SmsFacadeService {

    @ApiOperation(value = "1-3-7 验证指定类型的验证码")
    @GetMapping("/verify/type")
    Boolean verifySmsCodeByType(@RequestParam("type") Byte type,
                                @RequestParam("phoneNo") String phoneNo,
                                @RequestParam("code") String code);

    @ApiOperation(value = "1-3-5 发送验证码短信模板")
    @PostMapping("/tml/vcode")
    SendSmsResult sendSmsByVCodeTemplate(@RequestBody SmsSendParam smsSendParam);
}
