package com.bxm.localnews.msg.facade.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.facade.DingtalkFacadeService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class DingtalkFallbackFactory implements FallbackFactory<DingtalkFacadeService> {
    @Override
    public DingtalkFacadeService create(Throwable cause) {
        return new DingtalkFacadeService() {
            @Override
            public void pushDingtalk(DingtalkMessage message) {
                log.error("钉钉推送失败，消息内容：{}", JSON.toJSONString(message));
                log.error(cause.getMessage(), cause);
            }
        };
    }
}
