package com.bxm.localnews.msg.integration;

import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.msg.facade.MessageFacadeService;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 消息相关的集成服务接口
 *
 * @author liujia
 * @date 2020-07-15 21:40
 **/
@Service
public class MessageIntegrationService {

    private final MessageFacadeService messageFacadeService;

    @Autowired
    public MessageIntegrationService(MessageFacadeService messageFacadeService) {
        this.messageFacadeService = messageFacadeService;
    }

    /**
     * 获取用户某一个消息类目下的未读消息总数
     *
     * @param userId      用户ID
     * @param messageType 消息类型
     * @return 消息类型下未读消息总数
     */
    public Map<String, Long> getUnreadMap(Long userId, MessageTypeEnum messageType) {
        ResponseEntity<Map<String, Long>> entity = messageFacadeService.getUnReadMessageNum(userId, messageType.name());

        if (entity.hasBody()) {
            return entity.getBody();
        }

        return ImmutableMap.of(messageType.name(), 0L);
    }

}
