/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.integration;

import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.msg.facade.MessageFacadeService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MessageIntegrationService {
    private final MessageFacadeService messageFacadeService;

    @Autowired
    public MessageIntegrationService(MessageFacadeService messageFacadeService) {
        this.messageFacadeService = messageFacadeService;
    }

    public Map<String, Long> getUnreadMap(Long userId, MessageTypeEnum messageType) {
        ResponseEntity<Map<String, Long>> entity = this.messageFacadeService.getUnReadMessageNum(userId, messageType.name());
        if (entity.hasBody()) {
            return (Map)entity.getBody();
        }
        return ImmutableMap.of((Object)messageType.name(), (Object)0L);
    }
}

