/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.model.dto.PushAllMessage;
import com.bxm.localnews.mq.common.model.dto.PushGroupMessage;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.produce.service.PushMsgSupplyService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/push"})
public class PushMsgSupplyController {
    @Resource
    private PushMsgSupplyService pushMsgSupplyService;

    @PostMapping
    public void pushMsg(@RequestBody PushMessage message) {
        this.pushMsgSupplyService.pushMsg(message);
    }

    @PostMapping(value={"/group"})
    public void pushGroupMsg(@RequestBody PushGroupMessage pushGroupMessage) {
        List userIds = pushGroupMessage.getUserIds();
        PushMessage message = pushGroupMessage.getPushMessage();
        this.pushMsgSupplyService.pushGroupMsg(userIds, message);
    }

    @PostMapping(value={"/all"})
    public void pushMsgToAll(@RequestBody PushAllMessage pushAllMessage) {
        String title = pushAllMessage.getTitle();
        String content = pushAllMessage.getContent();
        PushPayloadInfo payloadInfo = pushAllMessage.getPushPayloadInfo();
        this.pushMsgSupplyService.pushMsgToAll(title, content, payloadInfo);
    }
}

