/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.mq.produce.service.SmsSupplyService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sms"})
public class SmsSupplyController {
    @Resource
    private SmsSupplyService smsSupplyService;

    @PostMapping(value={"/tml"})
    public SendSmsResult sendSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        String phoneNo = smsSupplyDTO.getPhoneNo();
        SmsTemplateEnum smsTemplate = smsSupplyDTO.getSmsTemplateEnum();
        String ip = smsSupplyDTO.getIp();
        String[] params = smsSupplyDTO.getParams();
        return this.smsSupplyService.sendSmsByTemplate(phoneNo, smsTemplate, ip, params);
    }

    @PostMapping(value={"/group/tml"})
    public void sendGroupSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        List phoneNos = smsSupplyDTO.getPhoneNos();
        SmsTemplateEnum smsTemplate = smsSupplyDTO.getSmsTemplateEnum();
        String[] params = smsSupplyDTO.getParams();
        this.smsSupplyService.sendGroupSmsByTemplate(phoneNos, smsTemplate, params);
    }

    @PostMapping(value={"/custom"})
    public SendSmsResult sendSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        return this.smsSupplyService.sendSmsByCustomize(smsSupplyDTO.getPhoneNo(), smsSupplyDTO.getContent());
    }

    @PostMapping(value={"/group/custom"})
    public void sendGroupSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        this.smsSupplyService.sendGroupSmsByCustomize(smsSupplyDTO.getPhoneNos(), smsSupplyDTO.getContent());
    }

    @PostMapping(value={"/tml/vcode"})
    public SendSmsResult sendSmsByVCodeTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        return this.smsSupplyService.sendSmsByVCodeTemplate(smsSupplyDTO.getPhoneNo(), smsSupplyDTO.getSmsTemplateEnum(), smsSupplyDTO.getIp());
    }

    @GetMapping(value={"/verify"})
    public Boolean verifySmsCode(@RequestParam(value="phoneNo") String phoneNo, @RequestParam(value="code") String code, @RequestParam(value="smsTemplate") SmsTemplateEnum smsTemplate) {
        return this.smsSupplyService.verifySmsCode(phoneNo, code, smsTemplate);
    }

    @GetMapping(value={"/verify/type"})
    public Boolean verifySmsCodeByType(@RequestParam(value="type") Byte type, @RequestParam(value="phoneNo") String phoneNo, @RequestParam(value="code") String code) {
        return this.smsSupplyService.verifySmsCodeByType(type, phoneNo, code);
    }
}

