/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.service.UserMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"5-90 \u7528\u6237\u6d88\u606f\u5217\u8868"}, description="\u83b7\u53d6\u7528\u6237\u7684\u6d88\u606f")
@RestController
@RequestMapping(value={"/facade/msg"})
public class MessageFacadeController {
    private final UserMessageService userMessageService;

    @Autowired
    public MessageFacadeController(UserMessageService userMessageService) {
        this.userMessageService = userMessageService;
    }

    @ApiOperation(value="5-90-1 \u8ba1\u7b97\u7528\u6237\u6d88\u606f\u7684\u603b\u6570\uff0c\u5728\u4e2a\u4eba\u4e2d\u5fc3\u663e\u793a")
    @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)
    @RequestMapping(value={"/number"}, method={RequestMethod.GET})
    @Deprecated
    public ResponseEntity<Integer> countTotalMsg(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)0);
    }

    @ApiOperation(value="5-90-2 \u6dfb\u52a0\u7528\u6237\u6d88\u606f")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResponseEntity<Boolean> addMsg(@RequestBody PushMessage pushMessage, @RequestParam(value="userId") Long userId) {
        this.userMessageService.addMessage(pushMessage, userId);
        return ResponseEntity.ok((Object)true);
    }

    @ApiOperation(value="5-90-3 \u6279\u91cf\u6dfb\u52a0\u7528\u6237\u672a\u8bfb\u6d88\u606f")
    @PostMapping(value={"batch/unread"})
    public void batchAddUnReadMsg(@RequestBody List<PushMessage> messages) {
        for (PushMessage message : messages) {
            this.userMessageService.addUnreadMsg(message, message.getPushReceiveScope().getUserId());
        }
    }

    @ApiOperation(value="5-90-4 \u8bbe\u7f6e\u7528\u6237\u67d0\u7c7b\u6d88\u606f\u4e3a\u5df2\u8bfb\u72b6\u6001")
    @PostMapping(value={"read"})
    public void setRead(@RequestParam(value="userId") Long userId, @RequestParam(value="msgType") String msgType) {
        this.userMessageService.updateMessageByType(userId, msgType);
    }

    @ApiOperation(value="5-90-5 \u6dfb\u52a0\u7528\u6237\u7684\u6700\u540e\u672a\u8bfb\u6d88\u606f")
    @PostMapping(value={"batch/last"})
    public void batchAddLastMsg(@RequestBody List<PushMessage> messages) {
        for (PushMessage message : messages) {
            this.userMessageService.addLastMsg(message);
        }
    }

    @ApiOperation(value="5-90-6 \u6839\u636e\u7c7b\u522b\u83b7\u53d6\u83b7\u53d6\u672a\u8bfb\u7684\u6d88\u606f\u6570")
    @GetMapping(value={"unread-num"})
    public ResponseEntity<Map<String, Long>> getUnReadMessageNum(@RequestParam(value="userId") Long userId, @RequestParam(value="messageType") String messageType) {
        return ResponseEntity.ok((Object)this.userMessageService.getUnReadNum(userId, messageType));
    }
}

