/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.mq.facade.controller;

import com.bxm.localnews.mq.common.constant.SmsTemplateEnum;
import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.msg.service.SmsSupplyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-3 \u77ed\u4fe1\u53d1\u9001\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/sms"})
public class SmsSupplyController {
    @Resource
    private SmsSupplyService smsSupplyService;

    @ApiOperation(value="1-3-1 \u53d1\u9001\u77ed\u4fe1\u6a21\u677f\u6d88\u606f")
    @PostMapping(value={"/tml"})
    public SendSmsResult sendSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        String phoneNo = smsSupplyDTO.getPhoneNo();
        SmsTemplateEnum smsTemplate = smsSupplyDTO.getSmsTemplateEnum();
        String ip = smsSupplyDTO.getIp();
        String[] params = smsSupplyDTO.getParams();
        return this.smsSupplyService.sendSmsByTemplate(phoneNo, smsTemplate, ip, params);
    }

    @ApiOperation(value="1-3-2 \u77ed\u4fe1\u6a21\u677f\u6d88\u606f\u7fa4\u53d1")
    @PostMapping(value={"/group/tml"})
    public void sendGroupSmsByTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        List phoneNos = smsSupplyDTO.getPhoneNos();
        SmsTemplateEnum smsTemplate = smsSupplyDTO.getSmsTemplateEnum();
        String[] params = smsSupplyDTO.getParams();
        this.smsSupplyService.sendGroupSmsByTemplate(phoneNos, smsTemplate, params);
    }

    @ApiOperation(value="1-3-3 \u53d1\u9001\u81ea\u5b9a\u4e49\u77ed\u4fe1")
    @PostMapping(value={"/custom"})
    public SendSmsResult sendSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        return this.smsSupplyService.sendSmsByCustomize(smsSupplyDTO.getPhoneNo(), smsSupplyDTO.getContent());
    }

    @ApiOperation(value="1-3-4 \u81ea\u5b9a\u4e49\u77ed\u4fe1\u7fa4\u53d1")
    @PostMapping(value={"/group/custom"})
    public void sendGroupSmsByCustomize(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        this.smsSupplyService.sendGroupSmsByCustomize(smsSupplyDTO.getPhoneNos(), smsSupplyDTO.getContent());
    }

    @ApiOperation(value="1-3-5 \u53d1\u9001\u9a8c\u8bc1\u7801\u77ed\u4fe1\u6a21\u677f")
    @PostMapping(value={"/tml/vcode"})
    public SendSmsResult sendSmsByVCodeTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO) {
        return this.smsSupplyService.sendSmsByVCodeTemplate(smsSupplyDTO.getPhoneNo(), smsSupplyDTO.getSmsTemplateEnum(), smsSupplyDTO.getIp());
    }

    @ApiOperation(value="1-3-6 \u9a8c\u8bc1\u77ed\u4fe1\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/verify"})
    public Boolean verifySmsCode(@RequestParam(value="phoneNo") String phoneNo, @RequestParam(value="code") String code, @RequestParam(value="smsTemplate") SmsTemplateEnum smsTemplate) {
        return this.smsSupplyService.verifySmsCode(phoneNo, code, smsTemplate);
    }

    @ApiOperation(value="1-3-7 \u9a8c\u8bc1\u6307\u5b9a\u7c7b\u578b\u7684\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/verify/type"})
    public Boolean verifySmsCodeByType(@RequestParam(value="type") Byte type, @RequestParam(value="phoneNo") String phoneNo, @RequestParam(value="code") String code) {
        return this.smsSupplyService.verifySmsCodeByType(type, phoneNo, code);
    }
}

