/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.integration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.localnews.msg.facade.PushTemplateMessageFeignService;
import com.bxm.newidea.component.vo.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class PushTemplateMessageIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(PushTemplateMessageIntegrationService.class);
    private final PushTemplateMessageFeignService pushTemplateMessageFeignService;

    @Autowired
    public PushTemplateMessageIntegrationService(PushTemplateMessageFeignService pushTemplateMessageFeignService) {
        this.pushTemplateMessageFeignService = pushTemplateMessageFeignService;
    }

    public void pushTemplateMessage(PushMessage pushMessage) {
        try {
            this.pushTemplateMessageFeignService.pushTemplateMessage(pushMessage, null);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5c0f\u7a0b\u5e8f\u6a21\u677f\u6d88\u606fbiz\u670d\u52a1\u51fa\u9519\uff1apushMessage\uff1a{}", (Object)JSONObject.toJSONString((Object)pushMessage), (Object)e);
        }
    }

    public Message pushOfficialAccountMsg(WechatMpPushMessage pushMessage) {
        ResponseEntity<Message> messageResponseEntity = null;
        try {
            messageResponseEntity = this.pushTemplateMessageFeignService.pushOfficialAccountMsg(pushMessage);
            if (log.isDebugEnabled()) {
                log.debug("\u63a8\u9001\u516c\u4f17\u53f7\u8fd4\u56de\u4fe1\u606f\uff1amessageResponseEntity\uff1a{}", (Object)JSON.toJSONString(messageResponseEntity));
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606fbiz\u670d\u52a1\u51fa\u9519\uff1apushMessage\uff1a{}", (Object)JSONObject.toJSONString((Object)pushMessage), (Object)e);
            return Message.build((boolean)false).setMessage("\u63a8\u9001\u516c\u4f17\u53f7\u6a21\u677f\u6d88\u606fbiz\u670d\u52a1\u51fa\u9519");
        }
        return (Message)messageResponseEntity.getBody();
    }
}

