package com.bxm.localnews.msg.facade;

import com.bxm.localnews.msg.facade.fallback.UserAuthFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-user", fallbackFactory = UserAuthFallbackFactory.class, primary = false)
public interface UserAuthFacadeService {

    /**
     * 根据userId获取微信用户信息
     *
     * @param userId 用户id
     * @param appId appId
     * @return openid
     */
    @GetMapping("/facade/user/auth/getFocusOfficialAccountOpenId")
    ResponseEntity<String> getFocusOfficialAccountOpenId(@RequestParam("userId") Long userId,@RequestParam("appId") String appId);
}
