package com.bxm.localnews.msg.facade;

import com.bxm.localnews.msg.facade.fallback.WechatFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author lowi
 * @date 2021/1/11 11:26
 */
@FeignClient(value = "localnews", fallbackFactory = WechatFallbackFactory.class, primary = false)
public interface WechatFacadeService {

    /**
     * 根据类型获取公众号appId
     *
     * @param type 类型
     * @return appid
     */
    @GetMapping("/facade/wechat/getOfficialAccountAppId")
    ResponseEntity<String> getOfficialAccountAppId(@RequestParam(value = "type") String type);
}

