package com.bxm.localnews.msg.facade.fallback;

import com.bxm.localnews.msg.facade.UserAuthFacadeService;
import com.bxm.localnews.msg.vo.UserAuth;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class UserAuthFallbackFactory implements FallbackFactory<UserAuthFacadeService> {

    @Override
    public UserAuthFacadeService create(Throwable throwable) {
        return new UserAuthFacadeService() {
            @Override
            public ResponseEntity<String> getFocusOfficialAccountOpenId(Long userId, String appId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(null);
            }
        };
    }
}
