package com.bxm.localnews.msg.facade.fallback;

import com.bxm.localnews.msg.facade.WechatFacadeService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author lowi
 * @date 2021/1/11 11:27
 */
@Component
@Slf4j
public class WechatFallbackFactory implements FallbackFactory<WechatFacadeService> {

    @Override
    public WechatFacadeService create(Throwable throwable) {
        return new WechatFacadeService() {
            @Override
            public ResponseEntity<String> getOfficialAccountAppId(String type) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }
        };
    }
}
