package com.bxm.localnews.msg.integration;

import com.bxm.localnews.msg.dto.AdvertDTO;
import com.bxm.localnews.msg.facade.AdvertFeignService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * @author zhaoyadong 2019/4/9 10:43
 * @desc
 */
@Service
@Slf4j
public class AdvertIntegrationService {

    private final AdvertFeignService advertFeignService;

    @Autowired
    public AdvertIntegrationService(AdvertFeignService advertFeignService) {
        this.advertFeignService = advertFeignService;
    }

    public List<AdvertDTO> getAdvertByType(String type, String areaCode, Long userId) {
        List<AdvertDTO> advertDTOS = null;
        try {
            advertDTOS = advertFeignService.getAdvertsByType(type, areaCode, userId).getBody();
        } catch (Exception e) {
            advertDTOS = Lists.newArrayList();
            log.error("内部接口biz获取广告类型错误：type:{},areaCode:{},userId:{}", type, areaCode, userId, e);
        }
        Objects.requireNonNull(advertDTOS).forEach(advertDTO -> advertDTO.setImgUrl(advertDTO.getIconUrl()));
        return advertDTOS;
    }
}
