package com.bxm.localnews.msg.integration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.localnews.msg.facade.PushTemplateMessageFeignService;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/6/12 15:49
 * @desc
 */
@Service
@Slf4j
public class PushTemplateMessageIntegrationService {

    private final PushTemplateMessageFeignService pushTemplateMessageFeignService;

    @Autowired
    public PushTemplateMessageIntegrationService(PushTemplateMessageFeignService pushTemplateMessageFeignService) {
        this.pushTemplateMessageFeignService = pushTemplateMessageFeignService;
    }

    public void pushTemplateMessage(PushMessage pushMessage) {
        //appid不传默认为万事通小程序
        try {
            pushTemplateMessageFeignService.pushTemplateMessage(pushMessage, null);
        } catch (Exception e) {
            log.error("推送小程序模板消息biz服务出错：pushMessage：{}", JSONObject.toJSONString(pushMessage), e);
        }
    }

    public Message pushOfficialAccountMsg(WechatMpPushMessage pushMessage) {
        ResponseEntity<Message> messageResponseEntity = null;
        try {
            messageResponseEntity = pushTemplateMessageFeignService.pushOfficialAccountMsg(pushMessage);
            if(log.isDebugEnabled()){
                log.debug("推送公众号返回信息：messageResponseEntity：{}", JSON.toJSONString(messageResponseEntity));
            }
        } catch (Exception e) {
            log.error("推送公众号模板消息biz服务出错：pushMessage：{}", JSONObject.toJSONString(pushMessage), e);
            return Message.build(false).setMessage("推送公众号模板消息biz服务出错");
        }
        return messageResponseEntity.getBody();
    }

}
