package com.bxm.localnews.msg.integration;

import com.bxm.localnews.msg.facade.UserAuthFacadeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/**
 * 用户服务调用封装
 *
 * @author lowi
 */
@Service
@Slf4j
public class UserAuthIntegrationService {
    @Autowired
    private UserAuthFacadeService userAuthFacadeService;


    public String getFocusOfficialAccountOpenId(Long userId,String appId) {
        ResponseEntity<String> openId;
        try {
            openId = userAuthFacadeService.getFocusOfficialAccountOpenId(userId,appId);
        } catch (Exception e) {
            log.error("获取user服务内部接口出错：userId:{}  ,", userId, e);
            return null;
        }
        return openId.getBody();
    }
}
