package com.bxm.localnews.msg.integration;

import com.bxm.localnews.msg.facade.WechatFacadeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author lowi
 * @date 2021/1/11 11:26
 */
@Service
@Slf4j
public class WechatIntegrationService {
    @Autowired
    private WechatFacadeService wechatFacadeService;

    public String getOfficialAccountAppId(String type) {
        ResponseEntity<String> officialAccountAppId = null;
        try {
            officialAccountAppId = wechatFacadeService.getOfficialAccountAppId(type);
        } catch (Exception e) {
            log.error("获取biz服务内部接口出错getOfficialAccountAppId：type:{}  ,", type, e);
            return null;
        }
        return officialAccountAppId.getBody();
    }
}

