package com.bxm.localnews.msg.param;

import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.newidea.component.vo.PageParam;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.util.Map;

/**
 * 用户分页查询参数，用于查询符合条件的用户用于推送
 *
 * @author liujia
 * @date 2020-07-04 14:57
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class UserSearchPageParam extends PageParam {

    @Tolerate
    public UserSearchPageParam() {
    }

    /**
     * 用户接收范围自定义规则类型
     */
    private PushReceiverRuleEnum pushReceiverRule;

    /**
     * 自定义规则对应的参数
     */
    private Map<String, Object> ruleParam;
}
