package com.bxm.localnews.msg.facade.fallback;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.facade.PushTemplateMessageFeignService;
import com.bxm.newidea.component.vo.Message;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/6/12 15:52
 * @desc
 */
@Component
@Slf4j
public class PushTemplateMessageFallbackFactory implements FallbackFactory<PushTemplateMessageFeignService> {

    @Override
    public PushTemplateMessageFeignService create(Throwable throwable) {
        return new PushTemplateMessageFeignService() {
            @Override
            public ResponseEntity<Message> pushTemplateMessage(PushMessage pushMessage, String appId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Message.build(false));
            }
        };
    }
}
