package com.bxm.localnews.msg.integration;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.msg.facade.AppVersionFeignService;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

/**
 * app版本服务集成
 *
 * @author zhaoyadong 2019/2/28 17:50
 */
@Service
public class AppVersionIntegrationService {

    private final AppVersionFeignService appVersionFeignService;

    private Cache<String, Boolean> cache;

    @Autowired
    public AppVersionIntegrationService(AppVersionFeignService appVersionFeignService) {
        this.appVersionFeignService = appVersionFeignService;
    }

    private void initCache() {
        cache = CacheBuilder.newBuilder()
                .expireAfterWrite(30, TimeUnit.SECONDS)
                .build();
    }

    private String buildKey(BasicParam param) {
        return param.getCurVer() + "_" + param.getPlatform() + "_" + param.getChnl();
    }

    /**
     * 是否处于提审状态
     *
     * @param param 基础参数
     * @return true表示当前app处于审核状态
     */
    public boolean getPublishState(BasicParam param) {
        initCache();

        String key = buildKey(param);

        Boolean isPublish = cache.getIfPresent(key);

        if (isPublish == null) {
            Boolean publish = appVersionFeignService.getPublishState(param).getBody();

            if (publish == null) {
                publish = Boolean.FALSE;
            }

            cache.put(key, publish);
        }

        return Boolean.TRUE.equals(isPublish);
    }

    /**
     * 增加即时通讯的版本
     *
     * @param param 基础信息
     * @return true表示为2.6.0之前的版本
     */
    public boolean beforeImVersion(BasicParam param) {
        return StringUtils.compareVersion(param.getCurVer(), "2.6.0") < 0;
    }

    /**
     * 消息中心重构之后的版本
     *
     * @param param 基础信息
     * @return true表示为3.0.0之前的版本
     */
    public boolean afterMsgCenterRebuild(BasicParam param) {
        return StringUtils.compareVersion(param.getCurVer(), "3.0.0") >= 0;
    }
}

