/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.integration;

import com.bxm.localnews.msg.dto.LocationDTO;
import com.bxm.localnews.msg.facade.LocationFeignService;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LocationIntegrationService {
    private Map<String, LocationDTO> localCacheMap = Maps.newConcurrentMap();
    private long nextRefreshTime = 0L;
    private static final Long CACHE_MILLISECOND = 300000L;
    @Resource
    private LocationFeignService locationFeignService;

    public LocationDTO getLocationByGeocode(String code) {
        LocationDTO location;
        if (StringUtils.isBlank((CharSequence)code)) {
            return new LocationDTO();
        }
        if (System.currentTimeMillis() > this.nextRefreshTime) {
            this.localCacheMap.clear();
            this.nextRefreshTime = System.currentTimeMillis() + CACHE_MILLISECOND;
        }
        if (null == (location = this.localCacheMap.get(code))) {
            location = (LocationDTO)this.locationFeignService.getLocationByGeocode(code).getBody();
            this.localCacheMap.put(code, location);
        }
        return location;
    }
}

