package com.bxm.localnews.msg.facade.fallback;

import com.bxm.localnews.msg.dto.LocationDTO;
import com.bxm.localnews.msg.facade.LocationFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/1 14:09
 * @desc
 */
@Component
@Slf4j
public class LocationFallbackFactory implements FallbackFactory<LocationFeignService> {

    @Override
    public LocationFeignService create(Throwable throwable) {
        return new LocationFeignService() {

            @Override
            public ResponseEntity<LocationDTO> getLocationByGeocode(String code) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new LocationDTO());
            }
        };
    }
}
