package com.bxm.localnews.msg.integration;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.facade.PushTemplateMessageFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/6/12 15:49
 * @desc
 */
@Service
public class PushTemplateMessageIntegrationService {

    private final PushTemplateMessageFeignService pushTemplateMessageFeignService;

    @Autowired
    public PushTemplateMessageIntegrationService(PushTemplateMessageFeignService pushTemplateMessageFeignService) {
        this.pushTemplateMessageFeignService = pushTemplateMessageFeignService;
    }

    public void pushTemplateMessage(PushMessage pushMessage) {
        //appid不传默认为万事通小程序
        pushTemplateMessageFeignService.pushTemplateMessage(pushMessage, null);
    }
}
