/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.integration;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.msg.facade.AppVersionFeignService;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppVersionIntegrationService {
    private final AppVersionFeignService appVersionFeignService;
    private Cache<String, Boolean> cache;

    @Autowired
    public AppVersionIntegrationService(AppVersionFeignService appVersionFeignService) {
        this.appVersionFeignService = appVersionFeignService;
    }

    private void initCache() {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    }

    private String buildKey(BasicParam param) {
        return param.getCurVer() + "_" + param.getPlatform() + "_" + param.getChnl();
    }

    public boolean getPublishState(BasicParam param) {
        this.initCache();
        String key = this.buildKey(param);
        Boolean isPublish = (Boolean)this.cache.getIfPresent((Object)key);
        if (isPublish == null) {
            Boolean publish = (Boolean)this.appVersionFeignService.getPublishState(param).getBody();
            if (publish == null) {
                publish = Boolean.FALSE;
            }
            this.cache.put((Object)key, (Object)publish);
        }
        return Boolean.TRUE.equals(isPublish);
    }

    public boolean beforeImVersion(BasicParam param) {
        return StringUtils.compareVersion((String)param.getCurVer(), (String)"2.6.0") < 0;
    }

    public boolean afterMsgCenterRebuild(BasicParam param) {
        return StringUtils.compareVersion((String)param.getCurVer(), (String)"3.0.0") >= 0;
    }
}

