package com.bxm.localnews.msg.manage.controller;

import com.bxm.localnews.msg.dto.AdminPushMessageDTO;
import com.bxm.localnews.msg.dto.PushMessageStatistical;
import com.bxm.localnews.msg.param.PushMessageParam;
import com.bxm.localnews.msg.service.AdminPushMessageService;
import com.bxm.localnews.msg.vo.AdminPushMessage;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.bxm.newidea.component.vo.ResponseJson;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

/**
 * V3.4.0 从运营后台迁移至消息服务
 *
 * @author liujia
 */
@Api(tags = "1-27 消息推送相关接口", description = "消息群体推送")
@RestController
@RequestMapping("/api/admin/push/message")
public class AdminPushMessageController extends BaseController {

    private AdminPushMessageService adminPushMessageService;

    @Autowired
    public AdminPushMessageController(AdminPushMessageService adminPushMessageService) {
        this.adminPushMessageService = adminPushMessageService;
    }

    @ApiOperation(value = "1-27-1 获取消息记录列表", notes = "根据输入参数获取对应的消息数据")
    @GetMapping("/list")
    public ResponseJson<PageWarper<AdminPushMessageDTO>> getPushMessageList(PushMessageParam pushMessageParam) {
        return ResponseJson.ok(this.adminPushMessageService.queryPushMessageList(pushMessageParam));
    }

    @ApiOperation(value = "1-27-3 获取推送消息详情", notes = "用于信息编辑")
    @ApiImplicitParam(name = "id", value = "活动id", required = true)
    @GetMapping("/getPushMessageDetail")
    public ResponseJson<AdminPushMessage> getActivityDetail(Long id) {
        return ResponseJson.ok(this.adminPushMessageService.getDetail(id));
    }

    @ApiOperation(value = "1-27-4 消息修改状态(取消推送)", notes = "取消推送，终止正在进行的推送")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "status", value = "状态", required = true)
    })
    @PostMapping("/updatePushMessage")
    public ResponseJson updatePushMessageStatusById(Long id, Byte status) {
        return ResponseJson.build(this.adminPushMessageService.updateStatusPushMessage(id, status));
    }

    @ApiOperation(value = "1-27-5 新增或编辑消息", notes = "")
    @PostMapping("/saveOrUpdatePushMessage")
    public ResponseJson addPushMessageDetail(AdminPushMessage adminPushMessage) {
        Message message = this.adminPushMessageService.saveOrUpdatePushMessage(adminPushMessage);
        return ResponseJson.build(message);
    }


    @ApiOperation(value = "1-27-6 对应消息的统计信息", notes = "统计消息的推送结果")
    @ApiImplicitParam(name = "messageId", value = "消息id", required = true)
    @GetMapping("/statistics")
    public ResponseJson<Collection<PushMessageStatistical>> statisticsMessage(Long messageId) {
        return ResponseJson.ok(this.adminPushMessageService.getStatistical(messageId));
    }


    @ApiOperation(value = "1-27-7 消息推送测试", notes = "群发消息前进行推送测试")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "消息id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @PostMapping("/test")
    public ResponseJson testPushMessage(Long id, Long userId) {
        return ResponseJson.ok(this.adminPushMessageService.testPushMessage(id, userId));
    }

    @ApiOperation(value = "1-27-8 消息推送", notes = "确定进行推送动作，二次确认过程")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true)
    })
    @PostMapping("/immediate")
    public ResponseJson immediatelyPushMessage(Long id) {
        return ResponseJson.ok(this.adminPushMessageService.immediatelyPushMessage(id));
    }

    @ApiOperation(value = "1-27-9 消息批量用户推送测试", notes = "测试多个用户推送")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "消息id", required = true),
            @ApiImplicitParam(name = "userIds", value = "用户id组, 以','分隔", required = true)
    })
    @PostMapping("/batch/test")
    public ResponseJson batchTestPushMessage(Long id, String userIds) {
        return ResponseJson.ok(this.adminPushMessageService.testPushMessage(id, userIds));
    }
}
